package gov.va.med.mhv.health.dto;

import gov.va.med.mhv.health.enums.ImmunizationEnumeration;
import gov.va.med.mhv.health.enums.OtherSymptomEnumeration;
import gov.va.med.mhv.health.enums.VaccinationMethodEnumeration;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

public class ImmunizationDTO  implements Serializable{

	private static final long serialVersionUID = 5420258276377968649L;
	
	private Long immunizationId;
	private Date dateReceived;
	private String comments;
	private String vaccinationMethod;
	private String vaccinationTypeCode;
	private String otherVaccine;
	private String reactionTypeCode;
	private Long userprofileId;
	private List<ImmunizationReactionDTO> reactions;
	private Boolean chills;
	private Boolean itchingWateryEyes;
	private Boolean lowBloodPressure;
	private Boolean drowsiness;
	private Boolean nausea;
	private Boolean diarrhea;
	private Boolean hives;
	private Boolean dryMouth;
	private Boolean dryNose;
	private Boolean rash;
	
	public Long getImmunizationId() {
		return immunizationId;
	}
	public void setImmunizationId(Long immunizationId) {
		this.immunizationId = immunizationId;
	}
	public Date getDateReceived() {
		return dateReceived;
	}
	public void setDateReceived(Date dateReceived) {
		this.dateReceived = dateReceived;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public String getVaccinationMethod() {
		return vaccinationMethod;
	}
	public void setVaccinationMethod(String vaccinationMethod) {
		this.vaccinationMethod = vaccinationMethod;
	}
	public String getVaccinationTypeCode() {
		return vaccinationTypeCode;
	}
	public void setVaccinationTypeCode(String vaccinationTypeCode) {
		this.vaccinationTypeCode = vaccinationTypeCode;
	}
	public String getOtherVaccine() {
		return otherVaccine;
	}
	public void setOtherVaccine(String otherVaccine) {
		this.otherVaccine = otherVaccine;
	}
	public String getReactionTypeCode() {
		return reactionTypeCode;
	}
	public void setReactionTypeCode(String reactionTypeCode) {
		this.reactionTypeCode = reactionTypeCode;
	}
	public Long getUserprofileId() {
		return userprofileId;
	}
	public void setUserprofileId(Long userprofileId) {
		this.userprofileId = userprofileId;
	}
	public List<ImmunizationReactionDTO> getReactions() {
		return reactions;
	}
	public void setReactions(List<ImmunizationReactionDTO> reactions) {
		this.reactions = reactions;
	}
	
	public Boolean getChills() {
		return chills;
	}
	public void setChills(Boolean chills) {
		this.chills = chills;
	}
	public Boolean getItchingWateryEyes() {
		return itchingWateryEyes;
	}
	public void setItchingWateryEyes(Boolean itchingWateryEyes) {
		this.itchingWateryEyes = itchingWateryEyes;
	}
	public Boolean getLowBloodPressure() {
		return lowBloodPressure;
	}
	public void setLowBloodPressure(Boolean lowBloodPressure) {
		this.lowBloodPressure = lowBloodPressure;
	}
	public Boolean getDrowsiness() {
		return drowsiness;
	}
	public void setDrowsiness(Boolean drowsiness) {
		this.drowsiness = drowsiness;
	}
	public Boolean getNausea() {
		return nausea;
	}
	public void setNausea(Boolean nausea) {
		this.nausea = nausea;
	}
	public Boolean getDiarrhea() {
		return diarrhea;
	}
	public void setDiarrhea(Boolean diarrhea) {
		this.diarrhea = diarrhea;
	}
	public Boolean getHives() {
		return hives;
	}
	public void setHives(Boolean hives) {
		this.hives = hives;
	}
	public Boolean getDryMouth() {
		return dryMouth;
	}
	public void setDryMouth(Boolean dryMouth) {
		this.dryMouth = dryMouth;
	}
	public Boolean getDryNose() {
		return dryNose;
	}
	public void setDryNose(Boolean dryNose) {
		this.dryNose = dryNose;
	}
	public Boolean getRash() {
		return rash;
	}
	public void setRash(Boolean rash) {
		this.rash = rash;
	}
	public ImmunizationEnumeration[] getImmunizations() {
		return ImmunizationEnumeration.values();
	}
	
	public VaccinationMethodEnumeration[] getVaccinationMethods() {
		return VaccinationMethodEnumeration.values();
	}
	
	public OtherSymptomEnumeration[] getOtherSymptoms() {
		return OtherSymptomEnumeration.values();
	}

}
